/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp.internal;

import com.aptana.core.io.vfs.ExtendedFileInfo;
import com.aptana.core.util.ExpiringMap;
import com.aptana.filesystem.ftp.Policy;
import com.aptana.filesystem.ftp.internal.BaseFTPConnectionFileManager;
import com.aptana.filesystem.secureftp.ISFTPConnectionFileManager;
import com.aptana.filesystem.secureftp.internal.Messages;
import com.aptana.filesystem.secureftp.internal.SFTPFileDownloadInputStream;
import com.aptana.filesystem.secureftp.internal.SFTPFileUploadOutputStream;
import com.aptana.filesystem.secureftp.internal.SSHHostValidator;
import com.aptana.filesystem.secureftp.internal.SecureFTPPlugin;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.PermissionDeniedException;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPAlgorithm;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.ftp.ssh.SSHFTPInputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPOutputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPValidator;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class SFTPConnectionFileManager
extends BaseFTPConnectionFileManager
implements ISFTPConnectionFileManager {
    private SSHFTPClient ftpClient;
    private IPath keyFilePath;
    private String transferType;
    private IPath cwd;
    private Map<IPath, FTPFile> ftpFileCache = new ExpiringMap(60000L);
    private Thread keepaliveThread;

    public void init(String host, int port, IPath basePath, IPath keyFilePath, String login, char[] password, String transferType, String encoding, String compression) {
        Assert.isTrue((this.ftpClient == null ? 1 : 0) != 0, (String)Messages.SFTPConnectionFileManager_ConnectionHasBeenInitialized);
        try {
            this.ftpClient = new SSHFTPClient();
            this.host = host;
            this.port = port;
            this.keyFilePath = keyFilePath;
            this.login = login;
            this.password = password == null ? new char[]{} : password;
            this.basePath = basePath != null ? basePath : Path.ROOT;
            this.authId = keyFilePath != null ? Policy.generateAuthId((String)"SFTP/PUBLICKEY", (String)login, (String)host, (int)port) : Policy.generateAuthId((String)"SFTP", (String)login, (String)host, (int)port);
            this.transferType = transferType;
            SFTPConnectionFileManager.initFTPClient(this.ftpClient, encoding, compression);
        }
        catch (Exception e) {
            SecureFTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_InitializationFailed, (Throwable)e));
            this.ftpClient = null;
        }
    }

    private static void initFTPClient(SSHFTPClient ftpClient, String encoding, String compression) throws IOException, FTPException {
        ftpClient.setTimeout(20000);
        ftpClient.setControlEncoding(encoding);
        ftpClient.setMonitorInterval(1024L);
        ftpClient.setSleepEnabled(false);
        if ("NONE".equals(compression)) {
            ftpClient.disableAllAlgorithms(1);
            ftpClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_NONE, true);
        } else if ("ZLIB".equals(compression)) {
            ftpClient.disableAllAlgorithms(1);
            ftpClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_ZLIB, true);
        }
        ftpClient.setTransportProvider(1);
        ftpClient.setConfigFlags(0);
        ftpClient.setTransferBufferSize(32768);
        ftpClient.setValidator((SSHFTPValidator)new SSHHostValidator());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.ftpClient != null ? 1 : 0) != 0, (String)Messages.SFTPConnectionFileManager_ConnectionNotInitialized);
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            try {
                this.cwd = null;
                this.cleanup();
                ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
                monitor.beginTask(Messages.SFTPConnectionFileManager_EstablishingConnection, -1);
                this.ftpClient.setRemoteHost(this.host);
                this.ftpClient.setRemotePort(this.port);
                while (true) {
                    block30: {
                        block29: {
                            SshPrivateKeyFile privateKeyFile;
                            block28: {
                                block26: {
                                    block27: {
                                        if (this.keyFilePath == null) break block26;
                                        try {
                                            privateKeyFile = SshPrivateKeyFile.parse((File)this.keyFilePath.toFile());
                                        }
                                        catch (InvalidSshKeyException e) {
                                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_InvalidPrivateKey, this.keyFilePath.toOSString()), (Throwable)e));
                                        }
                                        catch (IOException e) {
                                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_UnableToReadPrivateKey, this.keyFilePath.toOSString())));
                                        }
                                        if (!privateKeyFile.isPassphraseProtected() || this.password.length != 0) break block27;
                                        if (context == null || !context.getBoolean("no_password_prompt")) break block28;
                                        this.password = new char[0];
                                        break block29;
                                    }
                                    if (this.password == null) {
                                        this.password = new char[0];
                                    }
                                    break block29;
                                }
                                if (!(this.password.length != 0 || "anonymous".equals(this.login) || context != null && context.getBoolean("no_password_prompt"))) {
                                    this.getOrPromptPassword(MessageFormat.format(Messages.SFTPConnectionFileManager_SFTPAuthentication, this.host), Messages.SFTPConnectionFileManager_SpecifyPassword);
                                }
                                this.ftpClient.setAuthentication(this.login, String.copyValueOf(this.password));
                                break block30;
                            }
                            this.getOrPromptPassword(MessageFormat.format(Messages.SFTPConnectionFileManager_PublicKeyAuthentication, this.host, this.keyFilePath.toOSString()), Messages.SFTPConnectionFileManager_SpecifyPassphrase);
                            while (true) {
                                try {
                                    privateKeyFile.toPrivateKey(String.copyValueOf(this.password));
                                }
                                catch (InvalidSshKeyException e) {
                                    if (e.getCause() instanceof NoSuchAlgorithmException) {
                                        SecureFTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.secureftp", e.getCause().getMessage()));
                                    }
                                    this.promptPassword(MessageFormat.format(Messages.SFTPConnectionFileManager_PublicKeyAuthentication, this.host, this.keyFilePath.toOSString()), Messages.SFTPConnectionFileManager_PassphraseNotAccepted);
                                    continue;
                                }
                                break;
                            }
                        }
                        try {
                            this.ftpClient.setAuthentication(this.keyFilePath.toOSString(), this.login, String.copyValueOf(this.password));
                        }
                        catch (InvalidSshKeyException e) {
                            if (this.password.length == 0) {
                                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_KeyRequirePassphrase, this.keyFilePath.toOSString()), (Throwable)e));
                            }
                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_InvalidPassphrase, this.keyFilePath.toOSString()), (Throwable)e));
                        }
                    }
                    Policy.checkCanceled((IProgressMonitor)monitor);
                    monitor.subTask(Messages.SFTPConnectionFileManager_Authenticating);
                    try {
                        this.ftpClient.connect();
                    }
                    catch (SSHFTPException e) {
                        Policy.checkCanceled((IProgressMonitor)monitor);
                        if (this.keyFilePath != null) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedAuthenticatePublicKey, e.getLocalizedMessage()), (Throwable)e));
                        }
                        if (context != null && context.getBoolean("no_password_prompt")) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedAuthenticate, Messages.SFTPConnectionFileManager_IncorrectLogin), (Throwable)e));
                        }
                        this.promptPassword(MessageFormat.format(Messages.SFTPConnectionFileManager_SFTPAuthentication, this.host), Messages.SFTPConnectionFileManager_PasswordNotAccepted);
                        this.safeQuit();
                        continue;
                    }
                    break;
                }
                Policy.checkCanceled((IProgressMonitor)monitor);
                this.changeCurrentDir(this.basePath);
                this.ftpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
                this.initKeepAlive();
                return;
            }
            catch (OperationCanceledException e) {
                this.safeQuit();
                throw e;
            }
            catch (CoreException e) {
                this.safeQuit();
                throw e;
            }
            catch (UnknownHostException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.SFTPConnectionFileManager_HostNameNotFound) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.SFTPConnectionFileManager_RemoteFolderNotFound) + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (Exception e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", String.valueOf(Messages.SFTPConnectionFileManager_FailedEstablishConnection) + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void safeQuit() {
        try {
            if (this.ftpClient.connected()) {
                this.ftpClient.quit();
            }
        }
        catch (Exception e) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (Exception ignore) {
                ignore.getCause();
            }
        }
    }

    private void initKeepAlive() {
        Thread thread = this.keepaliveThread;
        if (thread != null && thread.isAlive()) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.keepaliveThread = new Thread(){

            public void run() {
                while (SFTPConnectionFileManager.this.ftpClient != null && SFTPConnectionFileManager.this.ftpClient.connected()) {
                    try {
                        SFTPConnectionFileManager.this.ftpClient.keepAlive();
                    }
                    catch (IOException e) {
                        if (SFTPConnectionFileManager.this.ftpClient.connected()) {
                            try {
                                SFTPConnectionFileManager.this.ftpClient.quitImmediately();
                            }
                            catch (Exception ignore) {
                                ignore.getCause();
                            }
                        }
                    }
                    catch (Exception e) {
                        SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_ErrorSendKeepAlive, (Throwable)e));
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                SFTPConnectionFileManager.this.keepaliveThread = null;
            }
        };
        this.keepaliveThread.start();
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
        try {
            this.checkConnected();
        }
        catch (Exception ignore) {
            ignore.getCause();
        }
        if (!this.isConnected()) {
            return;
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.SFTPConnectionFileManager_ClosingConnection, -1);
        try {
            try {
                this.ftpClient.quit();
            }
            catch (Exception e) {
                try {
                    this.ftpClient.quitImmediately();
                }
                catch (Exception ignore) {
                    ignore.getCause();
                }
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedDisconnectConnection, (Throwable)e));
            }
        }
        finally {
            this.cwd = null;
            this.cleanup();
            monitor.done();
        }
    }

    public boolean isConnected() {
        return this.ftpClient != null && this.ftpClient.connected();
    }

    protected void changeCurrentDir(IPath path) throws FTPException, IOException, PermissionDeniedException {
        try {
            if (this.cwd == null) {
                this.cwd = new Path(this.ftpClient.pwd());
            }
            if (!this.cwd.equals((Object)path)) {
                this.ftpClient.chdir(path.toPortableString());
                this.cwd = path;
            }
        }
        catch (FTPException e) {
            SFTPConnectionFileManager.throwWrappedException(e, path, 4);
        }
        catch (IOException e) {
            this.cwd = null;
            throw e;
        }
    }

    private static void throwWrappedException(FTPException e, IPath path) throws FileNotFoundException, FTPException, PermissionDeniedException {
        SFTPConnectionFileManager.throwWrappedException(e, path, -1);
    }

    private static void throwWrappedException(FTPException e, IPath path, int fileNotFoundErrorCode) throws FileNotFoundException, FTPException, PermissionDeniedException {
        int reply = e.getReplyCode();
        if (reply == -1 && e.getCause() instanceof FTPException) {
            reply = ((FTPException)e.getCause()).getReplyCode();
        }
        if (reply == -1 || reply == 2 || reply == 10 || reply == fileNotFoundErrorCode) {
            throw SFTPConnectionFileManager.initFileNotFoundException((IPath)path, (Throwable)e);
        }
        if (reply == 3) {
            throw new PermissionDeniedException(path.toPortableString(), (Exception)((Object)e));
        }
        throw e;
    }

    private static void fillFileInfo(ExtendedFileInfo fileInfo, FTPFile ftpFile) {
        fileInfo.setExists(true);
        fileInfo.setName(ftpFile.getName());
        fileInfo.setDirectory(ftpFile.isDir());
        fileInfo.setLength(ftpFile.size());
        fileInfo.setLastModified(ftpFile.lastModified() != null ? ftpFile.lastModified().getTime() : 0L);
        fileInfo.setOwner(ftpFile.getOwner());
        fileInfo.setGroup(ftpFile.getGroup());
        fileInfo.setPermissions(Policy.permissionsFromString((String)ftpFile.getPermissions()));
        if (ftpFile.isLink()) {
            fileInfo.setAttribute(32, true);
            fileInfo.setStringAttribute(64, ftpFile.getLinkedName().trim());
        }
    }

    private static ExtendedFileInfo createFileInfo(FTPFile ftpFile) {
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(ftpFile.getName());
        SFTPConnectionFileManager.fillFileInfo(fileInfo, ftpFile);
        return fileInfo;
    }

    protected void clearCache(IPath path) {
        super.clearCache(path);
        this.clearCacheAbsolute(this.basePath.append(path));
    }

    private void clearCacheAbsolute(IPath path) {
        int segments = path.segmentCount();
        for (IPath p : new ArrayList<IPath>(this.ftpFileCache.keySet())) {
            if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
            this.ftpFileCache.remove(p);
        }
    }

    protected void checkConnected() throws Exception {
        if (this.ftpClient.connected()) {
            try {
                this.ftpClient.keepAlive();
                return;
            }
            catch (FTPException e) {
                return;
            }
            catch (IOException ignore) {
                ignore.getCause();
                this.ftpClient.quitImmediately();
            }
        }
    }

    protected URI getRootCanonicalURI() {
        try {
            return new URI("sftp", this.login, this.host, this.port != 22 ? this.port : -1, Path.ROOT.toPortableString(), null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected ExtendedFileInfo fetchFile(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException, PermissionDeniedException {
        try {
            IPath dirPath = path.removeLastSegments(1);
            String name = path.lastSegment();
            FTPFile result = this.ftpFileCache.get(path);
            if (result == null) {
                FTPFile[] ftpFiles;
                if ((options & 0x800) != 0) {
                    ExtendedFileInfo fileInfo = new ExtendedFileInfo(path.lastSegment());
                    try {
                        fileInfo.setExists(this.ftpClient.exists(path.toPortableString()));
                        this.ftpClient.chdir(path.toPortableString());
                        fileInfo.setDirectory(true);
                    }
                    catch (FTPException e) {
                        try {
                            SFTPConnectionFileManager.throwWrappedException(e, path, 4);
                        }
                        catch (FileNotFoundException ignore) {
                            ignore.getCause();
                        }
                    }
                    return fileInfo;
                }
                FTPFile[] fTPFileArray = ftpFiles = this.listFiles(dirPath, monitor);
                int n = ftpFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    FTPFile ftpFile = fTPFileArray[n2];
                    String fileName = ftpFile.getName();
                    if (fileName == null || ".".equals(fileName) || "..".equals(fileName)) {
                        if (Path.ROOT.equals((Object)path) && ".".equals(fileName)) {
                            ftpFile.setName(path.toPortableString());
                            this.ftpFileCache.put(path, ftpFile);
                            result = ftpFile;
                        }
                    } else {
                        this.ftpFileCache.put(dirPath.append(fileName), ftpFile);
                        if (name != null && name.equals(fileName)) {
                            result = ftpFile;
                        }
                    }
                    ++n2;
                }
            }
            if (result != null) {
                return SFTPConnectionFileManager.createFileInfo(result);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedFetchFileInfo, (Throwable)e));
        }
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(path.lastSegment());
        fileInfo.setExists(false);
        return fileInfo;
    }

    protected ExtendedFileInfo[] fetchFiles(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException, PermissionDeniedException {
        monitor = Policy.subMonitorFor((IProgressMonitor)monitor, (int)1);
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            monitor.beginTask(Messages.SFTPConnectionFileManager_GatheringFileDetails, ftpFiles.length);
            ArrayList<ExtendedFileInfo> list = new ArrayList<ExtendedFileInfo>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String fileName = ftpFile.getName();
                if (fileName != null && ".".equals(fileName) || "..".equals(fileName)) {
                    monitor.worked(1);
                } else {
                    IPath filePath = path.append(fileName);
                    this.ftpFileCache.put(filePath, ftpFile);
                    ExtendedFileInfo fileInfo = SFTPConnectionFileManager.createFileInfo(ftpFile);
                    list.add(fileInfo);
                    monitor.worked(1);
                }
                ++n2;
            }
            ExtendedFileInfo[] extendedFileInfoArray = list.toArray(new ExtendedFileInfo[list.size()]);
            return extendedFileInfoArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedFetchDirectory, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected void createDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(path);
                return;
            }
            catch (FileNotFoundException ignore) {
                try {
                    ignore.getCause();
                    this.ftpClient.mkdir(path.toPortableString());
                    if (PreferenceUtils.getUpdatePermissions((PermissionDirection)PermissionDirection.UPLOAD) && PreferenceUtils.getSpecificPermissions((PermissionDirection)PermissionDirection.UPLOAD)) {
                        this.changeFilePermissions(path, PreferenceUtils.getFolderPermissions((PermissionDirection)PermissionDirection.UPLOAD), monitor);
                    }
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, path);
                }
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedCreateDirectory, (Throwable)e));
        }
    }

    protected void deleteDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        MultiStatus status = new MultiStatus("com.aptana.filesystem.secureftp", 0, null, null);
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled((IProgressMonitor)monitor);
                this.recursiveDeleteTree(path, monitor, status);
                this.changeCurrentDir(dirPath);
                this.ftpClient.rmdir(path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                if (status.isOK()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedDeleteDirectory, (Throwable)e));
                }
                MultiStatus multiStatus = new MultiStatus("com.aptana.filesystem.secureftp", 0, Messages.SFTPConnectionFileManager_FailedDeleteDirectory, (Throwable)e);
                multiStatus.addAll((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException, PermissionDeniedException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled((IProgressMonitor)monitor);
                try {
                    this.ftpClient.put((InputStream)new ByteArrayInputStream(new byte[0]), path.lastSegment());
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, path);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (PermissionDeniedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedDeletingFile, path), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void deleteFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled((IProgressMonitor)monitor);
                try {
                    this.ftpClient.delete(path.lastSegment());
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, path);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedDeletingFile, path), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void renameFile(IPath sourcePath, IPath destinationPath, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(sourcePath.removeLastSegments(1));
                Policy.checkCanceled((IProgressMonitor)monitor);
                if (this.ftpClient.exists(destinationPath.toPortableString())) {
                    this.ftpClient.delete(destinationPath.toPortableString());
                }
                try {
                    this.ftpClient.rename(sourcePath.toPortableString(), destinationPath.toPortableString());
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, sourcePath);
                    SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedRename, sourcePath, destinationPath), (Throwable)e));
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (PermissionDeniedException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_PermissionDenied0, sourcePath.toPortableString()), (Throwable)e));
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedRenaming, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void renameDirectory(IPath sourcePath, IPath destinationPath, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(sourcePath.removeLastSegments(1));
                Policy.checkCanceled((IProgressMonitor)monitor);
                if (this.ftpClient.exists(destinationPath.toPortableString())) {
                    this.changeCurrentDir(destinationPath.removeLastSegments(1));
                    this.ftpClient.rmdir(destinationPath.lastSegment());
                }
                try {
                    this.ftpClient.rename(sourcePath.toPortableString(), destinationPath.toPortableString());
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, sourcePath);
                    SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedRename, sourcePath, destinationPath), (Throwable)e));
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (PermissionDeniedException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_PermissionDenied0, sourcePath.toPortableString()), (Throwable)e));
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedRenaming, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String[] listDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> list = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (name != null && !".".equals(name) && !"..".equals(name)) {
                    this.ftpFileCache.put(path.append(name), ftpFile);
                    list.add(name);
                }
                ++n2;
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedListDirectory, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected InputStream readFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask(Messages.SFTPConnectionFileManager_InitiatingFileDownload, 4);
        try {
            Policy.checkCanceled((IProgressMonitor)monitor);
            this.changeCurrentDir(path.removeLastSegments(1));
            monitor.worked(1);
            Policy.checkCanceled((IProgressMonitor)monitor);
            try {
                SFTPFileDownloadInputStream sFTPFileDownloadInputStream = new SFTPFileDownloadInputStream((FileTransferInputStream)new SSHFTPInputStream(this.ftpClient, path.toPortableString()));
                return sFTPFileDownloadInputStream;
            }
            catch (FTPException e) {
                try {
                    SFTPConnectionFileManager.throwWrappedException(e, path);
                }
                catch (Exception e2) {
                    if (e2 instanceof OperationCanceledException) {
                        throw (OperationCanceledException)((Object)e2);
                    }
                    if (e2 instanceof FileNotFoundException) {
                        throw (FileNotFoundException)e2;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedOpeningFile, (Throwable)e2));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected OutputStream writeFile(final IPath path, boolean useTemporary, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask(Messages.SFTPConnectionFileManager_FailedInitiatingFile, 4);
        try {
            Policy.checkCanceled((IProgressMonitor)monitor);
            this.changeCurrentDir(path.removeLastSegments(1));
            monitor.worked(1);
            Policy.checkCanceled((IProgressMonitor)monitor);
            SFTPFileUploadOutputStream sFTPFileUploadOutputStream = new SFTPFileUploadOutputStream(this.ftpClient, (FileTransferOutputStream)new SSHFTPOutputStream(this.ftpClient, useTemporary ? path.removeLastSegments(1).append(SFTPConnectionFileManager.generateTempFileName(path.lastSegment())).toPortableString() : path.toPortableString()), useTemporary ? path.toPortableString() : null, new Date(), permissions, new Runnable(){

                public void run() {
                    SFTPConnectionFileManager.this.clearCacheAbsolute(path);
                }
            });
            return sFTPFileUploadOutputStream;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedOpeningFile, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected void setModificationTime(IPath path, long modificationTime, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled((IProgressMonitor)monitor);
                try {
                    this.ftpClient.setModTime(path.lastSegment(), new Date(modificationTime));
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, path);
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedSetModificationTime, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFileGroup(IPath path, String group, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled((IProgressMonitor)monitor);
                try {
                    int gid = Integer.parseInt(group);
                    this.ftpClient.changeGroup(gid, path.lastSegment());
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwWrappedException(e, path);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(Messages.SFTPConnectionFileManager_InvalidGroup);
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedChangeGroup, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFilePermissions(IPath path, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled((IProgressMonitor)monitor);
                this.ftpClient.changeMode((int)(permissions & 0x1FFL), path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPConnectionFileManager_FailedSetPermissions, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private FTPFile[] listFiles(IPath dirPath, IProgressMonitor monitor) throws IOException, ParseException, FTPException, PermissionDeniedException {
        Policy.checkCanceled((IProgressMonitor)monitor);
        try {
            return this.ftpClient.dirDetails(dirPath.toPortableString());
        }
        catch (FTPException e) {
            SFTPConnectionFileManager.throwWrappedException(e, dirPath);
            return null;
        }
    }

    private void recursiveDeleteTree(IPath path, IProgressMonitor monitor, MultiStatus status) throws IOException, ParseException {
        try {
            this.changeCurrentDir(path);
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> dirs = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (name != null && !".".equals(name) && !"..".equals(name)) {
                    if (ftpFile.isDir()) {
                        dirs.add(name);
                    } else {
                        Policy.checkCanceled((IProgressMonitor)monitor);
                        monitor.subTask(path.append(name).toPortableString());
                        try {
                            this.ftpClient.delete(name);
                        }
                        catch (FTPException e) {
                            status.add((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedDeleting, path.append(name).toPortableString()), (Throwable)e));
                        }
                        monitor.worked(1);
                    }
                }
                ++n2;
            }
            for (String name : dirs) {
                monitor.subTask(path.append(name).toPortableString());
                this.recursiveDeleteTree(path.append(name), monitor, status);
                Policy.checkCanceled((IProgressMonitor)monitor);
                this.changeCurrentDir(path);
                Policy.checkCanceled((IProgressMonitor)monitor);
                this.ftpClient.rmdir(name);
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            status.add((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SFTPConnectionFileManager_FailedDeleting, path.toPortableString()), (Throwable)e));
        }
    }

    private static String generateTempFileName(String base) {
        StringBuilder sb = new StringBuilder();
        sb.append(base).append("._tmp_upload");
        String ext = Path.fromPortableString((String)base).getFileExtension();
        if (ext != null) {
            sb.append(ext);
        }
        return sb.toString();
    }
}

